<?php
class InteractionController extends Controller {
    
    public function index() {
    session_start();
    if (!isset($_SESSION['user_id'])) {
        header("Location: " . BASE_URL . "/LoginController/index");
        exit;
    }

    $userId = $_SESSION['user_id'];
    $role = $_SESSION['user_role'];

    $interactionModel = $this->model('Interaction');

    $limit = 10;
    $page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
    $offset = ($page - 1) * $limit;

    $interactions = $interactionModel->getAllInteractions($userId, $role, $limit, $offset);
    $totalInteractions = $interactionModel->countAllInteractions($userId, $role);
    $totalPages = ceil($totalInteractions / $limit);

    $this->view('interactions/index', [
        'interactions' => $interactions,
        'role' => $role,
        'currentPage' => $page,
        'totalPages' => $totalPages
    ]);
}


    public function add($contactId = null) {
        session_start();
        if (!isset($_SESSION['user_id']) || !$contactId) {
            header("Location: " . BASE_URL . "/LoginController/index");
            exit;
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = [
                'contact_id' => $contactId,
                'user_id' => $_SESSION['user_id'],
                'type' => trim($_POST['type']),
                'summary' => trim($_POST['summary']),
                'interaction_date' => $_POST['interaction_date']
            ];

            $interactionModel = $this->model('Interaction');
            if ($interactionModel->addInteraction($data)) {
                header("Location: " . BASE_URL . "/InteractionController/contact/" . $contactId);
                exit;
            } else {
                $this->view('interactions/add', [
                    'error' => 'Failed to add interaction',
                    'data' => $data
                ]);
                return;
            }
        }

        $this->view('interactions/add', ['contact_id' => $contactId]);
    }

    public function edit($id = null) {
        session_start();
        if (!isset($_SESSION['user_id']) || !$id) {
            header("Location: " . BASE_URL . "/LoginController/index");
            exit;
        }

        $interactionModel = $this->model('Interaction');
        $interaction = $interactionModel->getInteractionById($id);

        if (!$interaction || ($_SESSION['user_role'] !== 'admin' && $interaction['user_id'] != $_SESSION['user_id'])) {
            header("Location: " . BASE_URL . "/contacts");
            exit;
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = [
                'type' => trim($_POST['type']),
                'summary' => trim($_POST['summary']),
                'interaction_date' => $_POST['interaction_date']
            ];

            if ($interactionModel->updateInteraction($id, $_SESSION['user_id'], $data)) {
                header("Location: " . BASE_URL . "/InteractionController/contact/" . $interaction['contact_id']);
                exit;
            } else {
                $this->view('interactions/edit', [
                    'error' => 'Failed to update interaction',
                    'interaction' => $interaction
                ]);
                return;
            }
        }

        $this->view('interactions/edit', ['interaction' => $interaction]);
    }

    public function delete($id = null) {
        session_start();
        if (!isset($_SESSION['user_id']) || !$id) {
            header("Location: " . BASE_URL . "/LoginController/index");
            exit;
        }

        $interactionModel = $this->model('Interaction');
        $interaction = $interactionModel->getInteractionById($id);

        if (!$interaction || ($_SESSION['user_role'] !== 'admin' && $interaction['user_id'] != $_SESSION['user_id'])) {
            header("Location: " . BASE_URL . "/contacts");
            exit;
        }

        if ($interactionModel->deleteInteraction($id, $_SESSION['user_id'])) {
            header("Location: " . BASE_URL . "/InteractionController/contact/" . $interaction['contact_id']);
            exit;
        } else {
            echo "Failed to delete interaction.";
        }
    }
    
    public function contact($contactId){
    session_start();
    if (!isset($_SESSION['user_id'])) {
        header("Location: " . BASE_URL . "/LoginController/index");
        exit;
    }

    $interactionModel = $this->model('Interaction');
    $contactModel = $this->model('Contact');

    $contact = $contactModel->getContactById($contactId);
    $interactions = $interactionModel->getInteractionsByContactId($contactId);

    $this->view('interactions/contact', [
        'contact' => $contact,
        'interactions' => $interactions
    ]);
}

}
?>
