<div class="container my-4">
    <div class="card shadow-sm">
        <div class="card-header bg-info text-white">
            <h4 class="mb-0">🧩 Assign Contacts to Agent</h4>
        </div>
        <div class="card-body">

            <!-- ✅ Success/Failure Messages -->
            <?php if (!empty($_GET['success'])): ?>
                <div class="alert alert-success">✅ Contacts assigned successfully.</div>
            <?php endif; ?>

            <?php if (!empty($_GET['error'])): ?>
                <div class="alert alert-danger">⚠️ <?= htmlspecialchars($_GET['error']) ?></div>
            <?php endif; ?>

            <!-- 🔍 Search -->
            <form method="GET" action="<?= BASE_URL ?>/contacts/assign" class="row g-2 mb-4">
                <div class="col-md-9">
                    <input type="text" name="q" class="form-control" placeholder="Search by name or email" value="<?= htmlspecialchars($search ?? '') ?>">
                </div>
                <div class="col-md-3">
                    <button class="btn btn-outline-primary w-100">Search</button>
                </div>
            </form>

            <?php if (empty($unassignedContacts)): ?>
                <div class="alert alert-warning">No unassigned contacts found.</div>
            <?php else: ?>

            <!-- ✅ Assign Form -->
            <form method="POST" action="<?= BASE_URL ?>/contacts/assignSubmit" onsubmit="return confirm('Assign selected contacts?');">

                <div class="mb-3">
                    <label for="agent_id" class="form-label">Assign to Agent</label>
                    <select name="agent_id" id="agent_id" class="form-select" required>
                        <option value="">-- Select Agent --</option>
                        <?php foreach ($agents as $agent): ?>
                            <option value="<?= $agent['id'] ?>"><?= htmlspecialchars($agent['name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-check mb-3">
                    <input type="checkbox" class="form-check-input" id="select-all">
                    <label class="form-check-label" for="select-all">Select All</label>
                </div>

                <!-- 📋 Table of Unassigned Contacts -->
                <div class="table-responsive">
                    <table class="table table-bordered table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>Select</th>
                                <th>Name</th>
                                <th>Email</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($unassignedContacts as $contact): ?>
                                <tr>
                                    <td>
                                        <input class="form-check-input contact-checkbox" type="checkbox" name="contact_ids[]" value="<?= $contact['id'] ?>">
                                    </td>
                                    <td><?= htmlspecialchars($contact['name']) ?></td>
                                    <td><?= htmlspecialchars($contact['email']) ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

                <div class="d-flex justify-content-between mt-3">
                    <button type="submit" class="btn btn-success">✅ Assign Selected</button>
                    <a href="<?= BASE_URL ?>/DashboardController/admin" class="btn btn-secondary">← Back to Dashboard</a>
                </div>
                <?php if ($totalPages > 1): ?>
                    <nav>
                        <ul class="pagination justify-content-center">
                            <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                                <li class="page-item <?= $i == $page ? 'active' : '' ?>">
                                    <a class="page-link" href="?q=<?= urlencode($search) ?>&page=<?= $i ?>"><?= $i ?></a>
                                </li>
                            <?php endfor; ?>
                        </ul>
                    </nav>
                <?php endif; ?>

            </form>

            <?php endif; ?>
        </div>
    </div>
</div>


<script>
    document.getElementById('select-all').addEventListener('change', function () {
        document.querySelectorAll('.contact-checkbox').forEach(cb => cb.checked = this.checked);
    });
</script>


