<div class="container mt-4">
  <div class="card shadow-sm">
    <div class="card-header bg-success text-white">
      <h4 class="mb-0">Add Payment</h4>
    </div>
    <div class="card-body">

      <?php if (!empty($error)): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
      <?php endif; ?>

      <form method="post" action="<?= BASE_URL ?>/payment/add">

        <!-- Invoice Selection -->
        <div class="mb-3">
            <label for="invoice_id" class="form-label fw-bold">Invoice</label>
            <select name="invoice_id" id="invoice_id" class="form-select" required>
                <option value="">-- Select Invoice --</option>
                <?php foreach ($invoices as $invoice): ?>
                    <option value="<?= $invoice['id'] ?>">#<?= str_pad($invoice['id'], 5, '0', STR_PAD_LEFT) ?> - <?= htmlspecialchars($invoice['customer_name']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="row g-3">
            <div class="col-md-4">
                <label for="amount" class="form-label fw-bold">Amount</label>
                <input type="number" step="0.01" name="amount" id="amount" class="form-control" required>
            </div>
            <div class="col-md-4">
                <label for="payment_date" class="form-label fw-bold">Payment Date</label>
                <input type="date" name="payment_date" id="payment_date" class="form-control" required>
            </div>
            <div class="col-md-4">
                <label for="method" class="form-label fw-bold">Payment Method</label>
                <select name="method" id="method" class="form-select" required>
                    <option value="">-- Select Method --</option>
                    <option value="Cash">Cash</option>
                    <option value="Bank Transfer">Bank Transfer</option>
                    <option value="Credit Card">Credit Card</option>
                </select>
            </div>
        </div>

        <div class="mb-3 mt-3">
            <label for="reference" class="form-label fw-bold">Reference</label>
            <input type="text" name="reference" id="reference" class="form-control">
        </div>

        <div class="mt-3">
            <button type="submit" class="btn btn-primary">Save Payment</button>
            <a href="<?= BASE_URL ?>/payment" class="btn btn-secondary">Cancel</a>
        </div>
      </form>
    </div>
  </div>
</div>
