<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3><i class="bi bi-credit-card"></i> Payments</h3>
        <div>
            <a href="<?= BASE_URL ?>/payment/add" class="btn btn-success">
                <i class="bi bi-plus-circle"></i> Add Payment
            </a>
            <a href="<?= BASE_URL ?>/dashboard" class="btn btn-secondary">
                <i class="bi bi-arrow-left"></i> Back to Dashboard
            </a>
        </div>
    </div>

    <!-- Flash messages -->
    <?php if (!empty($_SESSION['error'])): ?>
        <div class="alert alert-danger"><?= $_SESSION['error']; unset($_SESSION['error']); ?></div>
    <?php endif; ?>
    <?php if (!empty($_SESSION['success'])): ?>
        <div class="alert alert-success"><?= $_SESSION['success']; unset($_SESSION['success']); ?></div>
    <?php endif; ?>

    <!-- Filters -->
    <form method="get" class="row g-2 mb-4">
        <div class="col-md-2">
            <input type="text" name="id" class="form-control" placeholder="Payment #" value="<?= htmlspecialchars($filters['id'] ?? '') ?>">
        </div>
        <div class="col-md-3">
            <input type="text" name="invoice" class="form-control" placeholder="Invoice #" value="<?= htmlspecialchars($filters['invoice'] ?? '') ?>">
        </div>
        <div class="col-md-3">
            <input type="text" name="customer" class="form-control" placeholder="Customer" value="<?= htmlspecialchars($filters['customer'] ?? '') ?>">
        </div>
        <div class="col-md-2">
            <input type="date" name="payment_date" class="form-control" value="<?= htmlspecialchars($filters['payment_date'] ?? '') ?>">
        </div>
        <div class="col-md-2 text-end">
            <button type="submit" class="btn btn-primary"><i class="bi bi-search"></i> Search</button>
            <button type="button" class="btn btn-outline-secondary" onclick="window.location='<?= BASE_URL ?>/payment'">Reset</button>
        </div>
    </form>

    <!-- Payments table -->
    <?php if (!empty($payments)): ?>
        <div class="table-responsive">
            <table class="table table-hover table-bordered align-middle">
                <thead class="table-light">
                    <tr>
                        <th>ID</th>
                        <th>Invoice #</th>
                        <th>Customer</th>
                        <th>Amount</th>
                        <th>Payment Date</th>
                        <th>Method</th>
                        <th>Reference</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($payments as $payment): ?>
                        <tr class="text-center">
                            <td><?= str_pad($payment['id'], 5, '0', STR_PAD_LEFT) ?></td>
                            <td><?= str_pad($payment['invoice_id'], 5, '0', STR_PAD_LEFT) ?></td>
                            <td><?= htmlspecialchars($payment['customer_name']) ?></td>
                            <td>R<?= number_format($payment['amount'], 2) ?></td>
                            <td><?= htmlspecialchars($payment['payment_date']) ?></td>
                            <td><?= htmlspecialchars($payment['method']) ?></td>
                            <td><?= htmlspecialchars($payment['reference']) ?></td>
                            <td>
                                <a href="<?= BASE_URL ?>/payment/edit/<?= $payment['id'] ?>" class="btn btn-sm btn-outline-warning" title="Edit"><i class="bi bi-pencil"></i></a>
                                <a href="<?= BASE_URL ?>/payment/delete/<?= $payment['id'] ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Delete this payment?');" title="Delete"><i class="bi bi-trash"></i></a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if (!empty($totalPages) && $totalPages > 1): ?>
            <nav>
                <ul class="pagination justify-content-center">
                    <li class="page-item <?= ($currentPage <= 1) ? 'disabled' : '' ?>">
                        <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['page' => $currentPage - 1])) ?>">Previous</a>
                    </li>
                    <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                        <li class="page-item <?= ($i == $currentPage) ? 'active' : '' ?>">
                            <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['page' => $i])) ?>"><?= $i ?></a>
                        </li>
                    <?php endfor; ?>
                    <li class="page-item <?= ($currentPage >= $totalPages) ? 'disabled' : '' ?>">
                        <a class="page-link" href="?<?= http_build_query(array_merge($_GET, ['page' => $currentPage + 1])) ?>">Next</a>
                    </li>
                </ul>
            </nav>
        <?php endif; ?>
    <?php else: ?>
        <div class="alert alert-info text-center">
            <i class="bi bi-info-circle"></i> No payments found.
        </div>
    <?php endif; ?>
</div>
