<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2><i class="bi bi-list-task"></i> All Tasks</h2>
        <div>
           <a href="<?= BASE_URL ?>/ReminderController/manual" class="btn btn-outline-danger ">
            <i class="bi bi-send-check-fill me-1"></i> Send Task Reminders
        </a>
        <a href="<?= BASE_URL ?>/DashboardController/admin" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Back to Dashboard
        </a>  
        </div>
       
    </div>

    <!-- 🔍 Filter Buttons -->
    <div class="mb-3">
        <a href="<?= BASE_URL ?>/TaskController/index" class="btn btn-outline-secondary <?= !$statusFilter ? 'active' : '' ?>">All</a>
        <a href="<?= BASE_URL ?>/TaskController/index?status=pending" class="btn btn-outline-danger <?= $statusFilter === 'pending' ? 'active' : '' ?>">Pending</a>
        <a href="<?= BASE_URL ?>/TaskController/index?status=completed" class="btn btn-outline-success <?= $statusFilter === 'completed' ? 'active' : '' ?>">Completed</a>
        <a href="<?= BASE_URL ?>/TaskController/index?status=overdue" class="btn btn-outline-warning <?= $statusFilter === 'overdue' ? 'active' : '' ?>">Overdue</a>
    </div>
    
    <!-- 🔢 Task Status Summary -->
    <!--<div class="mb-4">-->
    <!--    <span class="badge bg-danger">Pending: <?= $stats['pending'] ?></span>-->
    <!--    <span class="badge bg-warning">Overdue: <?= $stats['overdue'] ?></span>-->
    <!--    <span class="badge bg-success">Completed: <?= $stats['completed'] ?></span>-->
    <!--</div>-->

    <!-- 📋 Task Table -->
    <div class="table-responsive">
        <table class="table table-hover table-bordered align-middle">
            <thead class="table-light">
                <tr>
                    <th>Title</th>
                    <th>Contact</th>
                    <th>Assigned To</th>
                    <th>Due Date</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
            <?php if (!empty($tasks)): ?>
                <?php foreach ($tasks as $task): ?>
                    <tr>
                        <td><?= htmlspecialchars($task['title']) ?></td>
                        <td><?= htmlspecialchars($task['contact_name']) ?></td>
                        <td><?= htmlspecialchars($task['agent_name']) ?></td>
                        <td><?= date('Y-m-d H:i', strtotime($task['due_date'])) ?></td>
                        <td>
                            <span class="badge bg-<?= 
                                $task['derived_status'] === 'completed' ? 'success' : 
                                ($task['derived_status'] === 'overdue' ? 'warning' : 'danger') ?>">
                                <?= ucfirst($task['derived_status']) ?>
                            </span>

                        </td>
                        <td>
                            <a href="<?= BASE_URL ?>/TaskController/adminedit/<?= $task['id'] ?>" class="btn btn-sm btn-outline-primary">
                                <i class="bi bi-pencil-square"></i> Edit
                            </a>
                            <a href="<?= BASE_URL ?>/TaskController/delete/<?= $task['id'] ?>" 
                               class="btn btn-sm btn-outline-danger"
                               onclick="return confirm('Are you sure you want to delete this task?')">
                                <i class="bi bi-trash"></i> Delete
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr><td colspan="6" class="text-center">No tasks found.</td></tr>
            <?php endif; ?>
            </tbody>

        </table>
    </div>
</div>
