<?php
require_once __DIR__ . '/tcpdf/tcpdf.php';

class DeliveryNotePDF extends TCPDF
{
    public function Header() {
        $imageFile = __DIR__ . '/../public/assets/logo.png';
        $this->Image($imageFile, 15, 10, 35, '', '', '', 'T', false, 300);

        // Company Info
        $this->SetFont('helvetica', 'B', 14);
        $this->SetXY(55, 12);
        $this->Cell(0, 6, 'TechLutry PTY LTD', 0, 1, 'R');

        $this->SetFont('helvetica', '', 10);
        $this->SetX(55);
        $this->Cell(0, 5, '11113 Modisane Street', 0, 1, 'R');
        $this->SetX(55);
        $this->Cell(0, 5, 'Thatch Hill Estate, Olivenhoutbosch', 0, 1, 'R');
        $this->SetX(55);
        $this->Cell(0, 5, 'Midrand, 0187, South Africa', 0, 1, 'R');
        $this->SetX(55);
        $this->Cell(0, 5, 'Phone: +27 79 329 9765', 0, 1, 'R');

        $this->Ln(12);
        $this->SetDrawColor(220, 220, 220);
        $this->Ln(5);
    }

    public function Footer() {
        $this->SetY(-25);
        $this->SetDrawColor(220, 220, 220);
        $this->Line(15, $this->GetY(), $this->getPageWidth() - 15, $this->GetY());

        $this->SetFont('helvetica', 'I', 8);
        $this->Ln(3);
        $this->Cell(0, 6, 'Page ' . $this->getAliasNumPage() . ' of ' . $this->getAliasNbPages(), 0, 1, 'C');

        $this->SetFont('helvetica', 'I', 9);
        $this->Cell(0, 6, 'Goods delivered as listed above.', 0, 0, 'C');
    }

    public function CustomerDetails($customer, $deliveryNote) {
        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(0, 6, 'DELIVERY NOTE', 0, 1, 'L');

        $this->SetFont('helvetica', '', 10);
        $this->Cell(95, 6, 'Delivery #: ' . $deliveryNote['id'], 0, 0, 'L');
        $this->Cell(85, 6, 'Date: ' . $deliveryNote['delivery_date'], 0, 1, 'R');
        $this->Ln(8);

        // Address Blocks
        $this->SetFont('helvetica', 'B', 11);
        $this->Cell(95, 6, 'From:', 0, 0);
        $this->Cell(95, 6, 'Delivered To:', 0, 1);

        $this->SetFont('helvetica', '', 10);
        $this->MultiCell(95, 5,
            "TechLutry PTY LTD\n11113 Modisane Street\nThatch Hill Estate, Olivenhoutbosch\nMidrand, 0187, South Africa\nPhone: +27 79 329 9765",
            0, 'L', false, 0
        );
        $this->MultiCell(95, 5,
            $customer['name'] . "\n" . $customer['address_1'] . " " . $customer['address_2'] . 
            "\n" . $customer['city'] . ", " . $customer['country'] . 
            "\nEmail: " . $customer['email'] . 
            "\nPhone: " . $customer['phone'],
            0, 'L', false, 1
        );

        $this->Ln(10);
    }

    public function ItemsTable($items) {
        // Table Header
        $this->SetFillColor(50, 50, 50);
        $this->SetTextColor(255);
        $this->SetDrawColor(180, 180, 180);
        $this->SetLineWidth(0.3);
        $this->SetFont('helvetica', 'B', 10);

        $this->Cell(80, 8, 'Product', 1, 0, 'L', true);
        $this->Cell(30, 8, 'Qty', 1, 0, 'C', true);
        $this->Cell(70, 8, 'Description', 1, 1, 'L', true);

        // Table Body
        $this->SetFont('helvetica', '', 9);
        $this->SetTextColor(0);
        $fill = false;

        foreach ($items as $item) {
            $this->SetFillColor($fill ? 245 : 255, $fill ? 245 : 255, $fill ? 245 : 255);
            $this->Cell(80, 8, $item['product_name'], 1, 0, 'L', true);
            $this->Cell(30, 8, $item['quantity'], 1, 0, 'C', true);
            $this->Cell(70, 8, $item['description'] ?? '', 1, 1, 'L', true);

            $fill = !$fill;
        }

        $this->Ln(15);
        $this->Cell(0, 6, 'Receiver Signature: _____________________________', 0, 1, 'L');
    }
}
