<?php

spl_autoload_register(function ($class) {
    $prefix = 'PhpOffice\\PhpSpreadsheet\\';
    $base_dir = __DIR__ . '/src/PhpSpreadsheet/';

    $psr_prefix = 'Psr\\SimpleCache\\';
    $psr_base_dir = __DIR__ . '/../Psr/SimpleCache/';
    
    // PhpSpreadsheet classes
    if (strpos($class, $prefix) === 0) {
        $relative_class = substr($class, strlen($prefix));
        $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';
        if (file_exists($file)) {
            require $file;
            return;
        }
    }

    // PSR SimpleCache interface
    if (strpos($class, $psr_prefix) === 0) {
        $relative_class = substr($class, strlen($psr_prefix));
        $file = $psr_base_dir . str_replace('\\', '/', $relative_class) . '.php';
        if (file_exists($file)) {
            require $file;
            return;
        }
    }
});
